﻿#pragma once

namespace RTCam {

class Entity;
class Camera;
class ResourceManager;

class Scene
{
public:
	Scene(void);
	~Scene(void);

	void Initialize(const shared_ptr<ResourceManager>& resources);
	
	void AddEntity(const shared_ptr<Entity>& entity);
	void RemoveEntity(const shared_ptr<Entity>& entity);

	// Functions for adding basic entities
	shared_ptr<Entity> AddCamera();
	shared_ptr<Entity> AddCube(const DirectX::XMFLOAT3A& position);
	shared_ptr<Entity> AddColorCube(const DirectX::XMFLOAT3A& position);
	

	vector<shared_ptr<Entity>> m_entities;
	weak_ptr<Camera> m_activeCam;

private:
	weak_ptr<ResourceManager> m_resources;
};

} // end namespace